<?php
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    if (isset($_FILES["image"]) && $_FILES["image"]["error"] === 0) {

        // Lấy tên file gốc
        $fileName = basename($_FILES["image"]["name"]);
        $fileType = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

        // Chỉ cho phép PNG
        if ($fileType !== "png") {
            die("❌ Chỉ cho phép upload file PNG.");
        }

        // Giới hạn dung lượng 2MB
        if ($_FILES["image"]["size"] > 2 * 1024 * 1024) {
            die("❌ File quá lớn (tối đa 2MB).");
        }

        // Kiểm tra có phải ảnh thật không
        if (!getimagesize($_FILES["image"]["tmp_name"])) {
            die("❌ File không phải là ảnh hợp lệ.");
        }

        // Đặt tên file mới để tránh trùng (random)
        $newFileName = "upload_" . time() . "_" . rand(1000, 9999) . ".png";

        // Lưu ngay trong thư mục hiện tại
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $newFileName)) {
            echo "✅ Upload thành công: <a href='$newFileName'>$newFileName</a><br>";
            echo "<img src='$newFileName' width='200'>";
        } else {
            echo "❌ Lỗi khi lưu file.";
        }

    } else {
        echo "⚠ Chưa chọn file hoặc có lỗi khi upload.";
    }
}
?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <title>Upload PNG</title>
</head>
<body>
    <h2>Upload ảnh PNG</h2>
    <form action="" method="post" enctype="multipart/form-data">
        <input type="file" name="image" accept=".png" required>
        <button type="submit">Upload</button>
    </form>
</body>
</html>