<?php

namespace App\kenc; // connect thay tên 

use App\Models\KeysModel;

class Connect extends BaseController
{
    protected $model, $game, $uKey, $sDev;
    private $encryptionKey = "ThisIsASecretKeyForAES256Encrypt";
    private $encryptionMethod = "AES-256-CBC";

    public function __construct()
    {
        include('conn.php');
        
        //=================================================
        $sql1 = "SELECT * FROM onoff WHERE id=1";
        $result1 = mysqli_query($conn, $sql1);
        $userDetails1 = mysqli_fetch_assoc($result1);
        
        // FIX: Check if the result is not null before accessing array keys
        if($userDetails1 && isset($userDetails1['status']) && $userDetails1['status'] == 'on') {
            $this->maintenance = true;
        } else {
            $this->maintenance = false;
        }
        //=================================================
        
        $this->model = new KeysModel();
        $this->staticWords = "Vm8Lk7Uj2JmsjCPVPVjrLa7zgfx3uz9E";
    }

    // Hàm giải mã dữ liệu AES-256-CBC
    private function decryptData($encryptedData)
    {
        if (empty($encryptedData)) {
            return null;
        }
        
        $encryptedData = base64_decode($encryptedData);
        if ($encryptedData === false || strlen($encryptedData) < 16) {
            return null;
        }
        
        $iv = substr($encryptedData, 0, 16);
        $ciphertext = substr($encryptedData, 16);
        
        $decrypted = openssl_decrypt($ciphertext, $this->encryptionMethod, $this->encryptionKey, OPENSSL_RAW_DATA, $iv);
        
        if ($decrypted === false) {
            return null;
        }
        
        return json_decode($decrypted, true);
    }

    // Hàm mã hóa dữ liệu AES-256-CBC
    private function encryptData($data)
    {
        if (is_array($data) || is_object($data)) {
            $data = json_encode($data);
        }
        
        $iv = openssl_random_pseudo_bytes(16);
        $encrypted = openssl_encrypt($data, $this->encryptionMethod, $this->encryptionKey, OPENSSL_RAW_DATA, $iv);
        
        return base64_encode($iv . $encrypted);
    }

    // Hàm xử lý dữ liệu đầu vào (POST/GET)
    private function getInputData($method = 'post')
    {
        $rawData = null;
        
        if ($method === 'post') {
            // Kiểm tra xem có dữ liệu mã hóa gửi đến không
            $rawInput = file_get_contents('php://input');
            
            if (!empty($rawInput)) {
                // Thử giải mã nếu dữ liệu được mã hóa
                $decryptedData = $this->decryptData($rawInput);
                
                if ($decryptedData !== null) {
                    return $decryptedData;
                } else {
                    // Nếu không giải mã được, thử phân tích JSON thông thường
                    $jsonData = json_decode($rawInput, true);
                    if ($jsonData !== null) {
                        return $jsonData;
                    }
                }
            }
            
            // Fallback: lấy dữ liệu POST thông thường
            return $this->request->getPost();
        } else {
            // GET request
            return $this->request->getGet();
        }
    }

    // Hàm validation tùy chỉnh cho dữ liệu mảng
    private function validateData($data, $rules)
    {
        foreach ($rules as $field => $rule) {
            $ruleParts = explode('|', $rule);
            
            foreach ($ruleParts as $part) {
                if ($part === 'required') {
                    if (!isset($data[$field]) || empty($data[$field])) {
                        return false;
                    }
                } elseif ($part === 'alpha_dash') {
                    if (isset($data[$field]) && !preg_match('/^[a-zA-Z0-9_-]+$/', $data[$field])) {
                        return false;
                    }
                } elseif (strpos($part, 'min_length[') === 0) {
                    preg_match('/min_length\[(\d+)\]/', $part, $matches);
                    $minLength = $matches[1] ?? 0;
                    if (isset($data[$field]) && strlen($data[$field]) < $minLength) {
                        return false;
                    }
                } elseif (strpos($part, 'max_length[') === 0) {
                    preg_match('/max_length\[(\d+)\]/', $part, $matches);
                    $maxLength = $matches[1] ?? 0;
                    if (isset($data[$field]) && strlen($data[$field]) > $maxLength) {
                        return false;
                    }
                }
            }
        }
        
        return true;
    }

    public function index()
    {
        if ($this->request->getPost() || !empty(file_get_contents('php://input'))) {
            return $this->index_post();
        } else {
            $nata = [
                "web_info" => [
                    "_client" => BASE_NAME,
                    "license" => "Qp5KSGTquetnUkjX6UVBAURH8hTkZuLM",
                    "version" => "1.0.0",
                ],
                "web__dev" => [
                    "author" => "@aypt09",
                    "telegram" => "https://t.me/aypt09"
                ],
            ];
            
            // Mã hóa response và trả về trực tiếp chuỗi mã hóa
            $encryptedResponse = $this->encryptData($nata);
            return $this->response->setJSON($encryptedResponse);
        }
    }

    public function index_post()
    {
        $isMT = $this->maintenance;
        
        // Lấy và giải mã dữ liệu đầu vào
        $inputData = $this->getInputData('post');
        
        // Nếu không có dữ liệu đầu vào
        if (empty($inputData)) {
            $data = ['status' => false, 'reason' => "No data received"];
            $encryptedResponse = $this->encryptData($data);
            return $this->response->setJSON($encryptedResponse);
        }
        
        // Trích xuất các tham số từ dữ liệu đã giải mã
        $game = isset($inputData['game']) ? $inputData['game'] : null;
        $uKey = isset($inputData['user_key']) ? $inputData['user_key'] : null;
        $sDev = isset($inputData['serial']) ? $inputData['serial'] : null;

        $form_rules = [
            'game' => 'required|alpha_dash',
            'user_key' => 'required|min_length[1]|max_length[36]',
            'serial' => 'required|alpha_dash'
        ];

        // Sử dụng hàm validation tùy chỉnh thay vì $this->validate()
        if (!$this->validateData($inputData, $form_rules)) {
            $data = ['status' => false, 'reason' => "Bad Parameter"];
            $encryptedResponse = $this->encryptData($data);
            return $this->response->setJSON($encryptedResponse);
        }

        if ($isMT) {
            include('conn.php');
            $sql1 = "select * from onoff where id=1";
            $result1 = mysqli_query($conn, $sql1);
            if ($result1 && mysqli_num_rows($result1) > 0) {
                $userDetails1 = mysqli_fetch_assoc($result1);
                $data = ['status' => true, 'reason' => $userDetails1['myinput']];
            } else {
                $data = ['status' => true, 'reason' => 'Maintenance Mode'];
            }
        } else {
            if (!$game or !$uKey or !$sDev) {
                $data = ['status' => false, 'reason' => 'INVALID PARAMETER'];
            } else {
                $time = new \CodeIgniter\I18n\Time;
                $model = $this->model;
                $findKey = $model->getKeysGame(['user_key' => $uKey, 'game' => $game]);

                if ($findKey) {
                    if ($findKey->status != 1) {
                        $data = ['status' => false, 'reason' => 'USER BLOCKED'];
                    } else {
                        $id_keys = $findKey->id_keys;
                        $duration = $findKey->duration;
                        $expired = $findKey->expired_date;
                        $max_dev = $findKey->max_devices;
                        $devices = $findKey->devices;
    
                        function checkDevicesAdd($serial, $devices, $max_dev)
                        {
                            $lsDevice = explode(",", $devices);
                            $cDevices = isset($devices) ? count($lsDevice) : 0;
                            $serialOn = in_array($serial, $lsDevice);
    
                            if ($serialOn) {
                                return true;
                            } else {
                                if ($cDevices < $max_dev) {
                                    array_push($lsDevice, $serial);
                                    $setDevice = reduce_multiples(implode(",", $lsDevice), ",", true);
                                    return ['devices' => $setDevice];
                                } else {
                                    return false;
                                }
                            }
                        }
    
                        if (!$expired) {
                            $setExpired = $time::now()->addHours($duration);
                            $model->update($id_keys, ['expired_date' => $setExpired]);
                            $data['status'] = true;
                            $expiry = $setExpired;
                        } else {
                            if ($time::now()->isBefore($expired)) {
                                $data['status'] = true;
                                $expiry = $expired;
                            } else {
                                $data = ['status' => false, 'reason' => 'EXPIRED KEY'];
                            }
                        }
    
                        if ($data['status']) {
                            include('conn.php');
                            
                            // Lấy modname
                            $modname = "VIP MOD";
                            $sql2 = "select * from modname where id=1";
                            $result2 = mysqli_query($conn, $sql2);
                            if ($result2 && mysqli_num_rows($result2) > 0) {
                                $userDetails2 = mysqli_fetch_assoc($result2);
                                $modname = $userDetails2['modname'] ?? "VIP MOD";
                            }
                            
                            // Lấy status và ftext
                            $mod_status = "Safe";
                            $credit = "MOD STATUS :- 100% SAFE";
                            $sql3 = "select * from _ftext where id=1";
                            $result3 = mysqli_query($conn, $sql3);
                            if ($result3 && mysqli_num_rows($result3) > 0) {
                                $userDetails3 = mysqli_fetch_assoc($result3);
                                $mod_status = $userDetails3['_status'] ?? "Safe";
                                $credit = $userDetails3['_ftext'] ?? "MOD STATUS :- 100% SAFE";
                            }
                            
                            // Lấy expired_date từ database
                            $expired_date_from_db = null;
                            $sql4 = "SELECT expired_date FROM keys_code WHERE user_key='$uKey'";
                            $result4 = mysqli_query($conn, $sql4);
                            if ($result4 && mysqli_num_rows($result4) > 0) {
                                $userDetails4 = mysqli_fetch_assoc($result4);
                                $expired_date_from_db = $userDetails4['expired_date'] ?? null;
                            }
                            
                            // Sử dụng giá trị mặc định cho feature status
                            $featureStatus = [
                                'ESP' => 'on', 
                                'Item' => 'on', 
                                'AIM' => 'on', 
                                'SilentAim' => 'on',
                                'BulletTrack' => 'on', 
                                'Floating' => 'on', 
                                'Memory' => 'on', 
                                'Setting' => 'on'
                            ];
                            
                            $rngcnt = $time->getTimestamp();
                            
                            $devicesAdd = checkDevicesAdd($sDev, $devices, $max_dev);
                            if ($devicesAdd) {
                                if (is_array($devicesAdd)) {
                                    $model->update($id_keys, $devicesAdd);
                                }
                                
                                $real = "$game-$uKey-$sDev-$this->staticWords";
                                
                                // Xử lý định dạng thời gian
                                if ($expiry instanceof \CodeIgniter\I18n\Time) {
                                    $expiryFormatted = $expiry->format('Y-m-d H:i:s');
                                } else {
                                    // Nếu $expiry là string, sử dụng trực tiếp
                                    $expiryFormatted = $expiry;
                                }
                                
                                // Sử dụng expired_date từ database hoặc từ $expiry
                                $expired_date = $expired_date_from_db ?: $expiryFormatted;
                                
                                $data = ['status'=>true,'data'=>['ftext'=>null,'FuckYOU'=>1,'status'=>null,'ON_OFF_BGMI'=>'on','SCK'=>'V2','real'=>$real,'token'=>md5($real),'modname'=>$modname,'mod_status'=>$mod_status,'credit'=>$credit,'ESP'=>$featureStatus['ESP'],'Item'=>$featureStatus['Item'],'AIM'=>$featureStatus['AIM'],'SilentAim'=>$featureStatus['SilentAim'],'BulletTrack'=>$featureStatus['BulletTrack'],'Floating'=>$featureStatus['Floating'],'Memory'=>$featureStatus['Memory'],'Setting'=>$featureStatus['Setting'],'expired_date'=>$expired_date,'EXP'=>$expiryFormatted,'ts'=>$expiryFormatted,'exdate'=>$expiryFormatted,'device'=>$max_dev,'rng'=>$rngcnt]];
                            } else {
                                $data = ['status' => false, 'reason' => 'MAX DEVICE REACHED'];
                            }
                        }
                    }
                } else {
                    $data = ['status' => false, 'reason' => 'USER OR GAME NOT REGISTERED'];
                }
            }
        }
        
        // Mã hóa response và trả về trực tiếp chuỗi mã hóa
        $encryptedResponse = $this->encryptData($data);
        return $this->response->setJSON($encryptedResponse);
    }
}