<?= $this->extend('Layout/Starter') ?>
<?= $this->section('content') ?>

<div class="row justify-content-center">
    <div class="col-lg-12">
        <?= $this->include('Layout/msgStatus') ?>
    </div>

    <!-- CHANGE PASSWORD -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow-sm border-0 rounded-4">
            <div class="card-header h6 p-3 text-white bg-danger rounded-top">
                <i class="bi bi-shield-lock-fill me-2"></i> Change Password
            </div>

            <div class="card-body p-4">
                <?= form_open() ?>
                <input type="hidden" name="password_form" value="1">

                <div class="mb-3">
                    <label class="form-label">Current Password</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-key-fill"></i></span>
                        <input type="password" name="current" class="form-control" placeholder="Current password">
                    </div>
                    <?php if ($validation->hasError('current')) : ?>
                        <small class="text-danger"><?= $validation->getError('current') ?></small>
                    <?php endif; ?>
                </div>

                <div class="mb-3">
                    <label class="form-label">New Password</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-lock-fill"></i></span>
                        <input type="password" name="password" class="form-control" placeholder="New password">
                    </div>
                    <?php if ($validation->hasError('password')) : ?>
                        <small class="text-danger"><?= $validation->getError('password') ?></small>
                    <?php endif; ?>
                </div>

                <div class="mb-3">
                    <label class="form-label">Confirm New Password</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-lock"></i></span>
                        <input type="password" name="password2" class="form-control" placeholder="Confirm password">
                    </div>
                    <?php if ($validation->hasError('password2')) : ?>
                        <small class="text-danger"><?= $validation->getError('password2') ?></small>
                    <?php endif; ?>
                </div>

                <button class="btn btn-danger w-100 py-2">
                    <i class="bi bi-check-circle me-1"></i> Update Password
                </button>

                <?= form_close() ?>
            </div>
        </div>
    </div>

    <!-- ACCOUNT INFO -->
    <div class="col-lg-6 mb-4">
        <div class="card shadow-sm border-0 rounded-4">
            <div class="card-header h6 p-3 text-white bg-dark rounded-top">
                <i class="bi bi-person-badge-fill me-2"></i> Account Information
            </div>

            <div class="card-body p-4">
                <?= form_open() ?>
                <input type="hidden" name="fullname_form" value="1">

                <div class="mb-3">
                    <label class="form-label">Name Menu</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-person-fill"></i></span>
                        <input type="text" name="fullname" id="fullname" class="form-control" placeholder="Maru-kun"
                               value="<?= old('fullname') ?: ($user->fullname ?: '') ?>">
                    </div>
                    <?php if ($validation->hasError('fullname')) : ?>
                        <small class="text-danger"><?= $validation->getError('fullname') ?></small>
                    <?php endif; ?>
                </div>

                <button class="btn btn-dark w-100 py-2">
                    <i class="bi bi-save2-fill me-1"></i> Update Name
                </button>

                <?= form_close() ?>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>