<?= $this->extend('Layout/Starter') ?>
<?= $this->section('content') ?>

<!-- Popup Welcome -->
<div id="popup-welcome" class="popup-welcome shadow-lg rounded" style="display:none;">
    <div class="popup-inner">
        <div class="mb-3">
            <i class="fa-solid fa-hand-wave text-primary fa-2x"></i>
        </div>
        <h5 class="fw-bold mb-2">Xin chào 👋</h5>
        <p class="small text-muted mb-3">Chào mừng bạn quay trở lại hệ thống 🎉</p>
        <button class="btn btn-sm btn-primary w-100" onclick="closePopup()">
            <i class="fa-solid fa-arrow-right"></i> Bắt đầu
        </button>
    </div>
</div>

<div class="row justify-content-center fade-in">
    <div class="col-lg-10">
        <div class="row g-4">

            <!-- Lịch sử Key -->
            <div class="col-md-8">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-gradient-primary text-white py-2 px-3 fw-semibold rounded-top d-flex align-items-center">
                        <i class="fa-solid fa-clock-rotate-left me-2"></i> Lịch sử Key
                    </div>
                    <div class="card-body p-3">
                        <div class="table-responsive small">
                            <table class="table table-bordered table-hover text-center align-middle mb-0 rounded">
                                <thead class="table-light">
                                    <tr class="small text-uppercase text-muted">
                                        <th>#</th>
                                        <th>Game</th>
                                        <th>Key</th>
                                        <th>Thời hạn</th>
                                        <th>Thiết bị</th>
                                        <th>Thời gian</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($history as $h): ?>
                                        <?php $in = explode("|", $h->info) ?>
                                        <tr>
                                            <td><span class="badge bg-secondary">#<?= $h->id_history ?></span></td>
                                            <td><i class="fa-solid fa-user text-primary me-1"></i><?= esc($in[0]) ?></td>
                                            <td><code><?= esc($in[1]) ?>**</code></td>
                                            <td><span class="badge bg-warning text-dark"><?= esc($in[2]) ?>h</span></td>
                                            <td><span class="badge bg-info text-dark"><i class="fa-solid fa-mobile-screen-button me-1"></i><?= esc($in[3]) ?></span></td>
                                            <td><small class="text-muted"><i class="fa-regular fa-clock me-1"></i><?= $time::parse($h->created_at)->humanize() ?></small></td>
                                        </tr>
                                    <?php endforeach ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Thông tin user -->
            <div class="col-md-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-gradient-primary text-white text-center py-2 fw-semibold rounded-top">
                        <i class="fa-solid fa-user-shield me-1"></i> Thông tin Tài khoản
                    </div>
                    <div class="card-body p-3">
                        <div class="d-flex align-items-center mb-3">
                            <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width:50px; height:50px;">
                                <i class="fa-solid fa-user fa-lg"></i>
                            </div>
                            <div>
                                <h6 class="mb-0 fw-bold"><?= esc($user->username ?? 'User') ?></h6>
                                <small class="text-muted"><?= getLevel($user->level) ?></small>
                            </div>
                        </div>
                        <ul class="list-group small mb-3">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Chức vụ
                                <span class="badge bg-light text-dark"><?= getLevel($user->level) ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Số dư
                                <span class="badge bg-success text-white"><?= number_format($user->saldo) ?> VND</span>
                            </li>
                        </ul>
                        <ul class="list-group small">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Lần đăng nhập
                                <span class="text-muted"><i class="fa-regular fa-clock me-1"></i><?= $time::parse('2025-10-03 07:30:00')->humanize() ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Thời lượng phiên
                                <span class="text-muted"><i class="fa-solid fa-hourglass-half me-1"></i><?= $time::now()->difference($time::parse('2025-10-03 07:30:00'))->humanize() ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('css') ?>
<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
/* Background + transition */
body {
    background-image: url('https://i.ibb.co/hRr1DMVm/683e09926ce542f20e6508569e6facd5.webp');
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    opacity: 0;
    transition: opacity 0.8s ease-in-out;
}
body.loaded { opacity: 1; }

/* Card */
.card {
    background-color: rgba(255, 255, 255, 0.92);
    border-radius: 12px;
    box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 12px 24px rgba(0, 0, 0, 0.12);
}
.card-header {
    font-size: 1rem;
    letter-spacing: 0.5px;
    background: linear-gradient(90deg, #007bff, #0dcaf0);
}

/* Table */
.table tbody tr:nth-child(even) { background-color: #fafafa; }
.table tbody tr:hover {
    background-color: #f2f6ff;
    transition: background-color 0.3s ease;
}

/* Badge + Code */
.badge {
    font-size: 0.75rem;
    padding: 0.4em 0.6em;
    border-radius: 8px;
}
code {
    font-size: 0.85rem;
    background-color: #f3f3f3;
    padding: 2px 6px;
    border-radius: 4px;
}

/* List group */
.list-group-item {
    border: none;
    transition: background-color 0.3s ease;
    border-radius: 6px;
}
.list-group-item:hover { background-color: #f8f9fa; }

/* Fade in */
.fade-in { animation: fadeIn 1s ease-in-out; }
@keyframes fadeIn {
    from {opacity: 0; transform: translateY(10px);}
    to {opacity: 1; transform: translateY(0);}
}

/* Popup Welcome */
.popup-welcome {
    position: fixed;
    top: 50%; left: 50%;
    transform: translate(-50%, -50%);
    background: #fff;
    padding: 1.5rem;
    border-radius: 12px;
    z-index: 9999;
    max-width: 320px;
    width: 90%;
    box-shadow: 0 10px 25px rgba(0,0,0,0.2);
    animation: popupFade 0.6s ease-out;
}
.popup-inner { text-align: center; }
@keyframes popupFade {
    from { opacity: 0; transform: translate(-50%, -60%) scale(0.95); }
    to { opacity: 1; transform: translate(-50%, -50%) scale(1); }
}

/* Responsive */
@media (max-width: 768px) {
    .card-header { font-size: 0.95rem; text-align: center; }
    .card-body { padding: 1rem; }
    .table-responsive { overflow-x: auto; }
    table { font-size: 0.8rem; white-space: nowrap; }
    .list-group-item { font-size: 0.85rem; }
    .col-md-8, .col-md-4 { flex: 0 0 100%; max-width: 100%; }
}
</style>

<script>
window.addEventListener('load', () => {
    document.body.classList.add('loaded');
    setTimeout(() => {
        const popup = document.getElementById('popup-welcome');
        if (popup) popup.style.display = 'block';
    }, 600);
});
function closePopup() {
    const popup = document.getElementById('popup-welcome');
    if (popup) popup.style.display = 'none';
}
</script>

<?= $this->endSection() ?>