<?= $this->extend('Layout/Starter') ?>
<?= $this->section('content') ?>

<style>
html, body {
    margin: 0;
    padding: 0;
    font-family: "Segoe UI", Arial, sans-serif;
    background-image: url('https://i.ibb.co/hRr1DMVm/683e09926ce542f20e6508569e6facd5.webp');
    background-size: cover;
    background-position: center;
    background-attachment: fixed;
    height: 100%;
}

/* Đẩy nội dung xuống dưới navbar fixed */
.main-wrapper {
    padding-top: 110px;
}
@supports(padding-top: env(safe-area-inset-top)) {
.main-wrapper {
    padding-top: 40px !important;
}
}

body::before {
    content: "";
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.4);
    z-index: -1;
}

/* Card */
.info-card {
    background: rgba(255,255,255,0.92);
    border-radius: 18px;
    padding: 20px;
    box-shadow: 0 6px 25px rgba(0,0,0,0.35);
    margin-bottom: 20px;
    backdrop-filter: blur(8px);
}

.section-title {
    font-size: 27px;
    font-weight: bold;
    text-align: center;
    padding: 14px;
    border-radius: 14px;
    background: linear-gradient(45deg, #007bff, #3399ff);
    color: white;
    margin-bottom: 25px;
}

.info-row {
    font-size: 16px;
    margin-bottom: 6px;
}
.info-row b {
    color: #0056d6;
}

.key-box {
    padding: 12px;
    background: #e9f4ff;
    border-left: 5px solid #1d8fff;
    border-radius: 8px;
    font-size: 18px;
    font-weight: bold;
    word-break: break-word;
}

.copy-btn {
    color: #007bff;
    cursor: pointer;
    margin-left: 8px;
}
.copy-btn:hover { opacity: 0.7; }

.alert-premium {
    background: rgba(0, 172, 193, 0.9);
    color: white;
    padding: 14px;
    border-radius: 10px;
    font-size: 14px;
    margin-top: 15px;
}

/* Style cho key generation type */
.key-gen-type .form-check-label {
    font-weight: 500;
}

.custom-key-field {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    border: 1px solid #dee2e6;
    margin-top: 10px;
}

.key-example {
    font-size: 12px;
    color: #6c757d;
    margin-top: 5px;
}
</style>

<div class="main-wrapper">
<div class="container">

    <div class="row justify-content-center">
        <div class="col-lg-6">

            <?= $this->include('Layout/msgStatus') ?>


<!-- ===================================================
     HIỂN THỊ KEY ĐÃ TẠO – CARD PREMIUM
=================================================== -->
<?php if (session()->getFlashdata('user_key')) :

    $key   = trim(session()->getFlashdata('user_key'));
    $type  = strtoupper(session()->getFlashdata('key_type'));
    $fees  = session()->getFlashdata('fees');
    $saldoAfter = session()->getFlashdata('saldo_after') ?? ($user->saldo ?? 0);
    $creator = session()->getFlashdata('creator_name') ?? $user->username;
    $generatedTime = session()->getFlashdata('generated_at') ?? date("d/m/Y H:i");
?>

<div class="info-card">

    <h4 class="text-success"><i class="bi bi-check-circle-fill"></i> Tạo Key Thành Công!</h4>
    <hr>

    <!-- KEY -->
    <div class="key-box">
        <?= esc($key) ?>
        <i class="bi bi-clipboard copy-btn" onclick="copyText('<?= esc($key, 'js') ?>')"></i>
    </div>

    <!-- THÔNG TIN CHI TIẾT -->
    <div class="info-row"><b>Loại Key:</b> <?= esc($type) ?></div>
    <div class="info-row"><b>Tạo bởi:</b> <?= esc($creator) ?></div>
    <div class="info-row"><b>Game:</b> <?= esc(session()->getFlashdata('game')) ?></div>
    <div class="info-row"><b>Thời hạn:</b> <?= esc(session()->getFlashdata('duration')) ?> giờ</div>
    <div class="info-row"><b>Số thiết bị:</b> <?= esc(session()->getFlashdata('max_devices')) ?></div>
    <div class="info-row"><b>Thời gian tạo:</b> <?= esc($generatedTime) ?></div>

    <!-- TIỀN -->
    <div class="info-row mt-2"><b>Trừ tiền:</b> -<?= number_format($fees) ?> VND</div>
    <div class="info-row"><b>Số dư còn lại:</b> <?= number_format($saldoAfter) ?> VND</div>

    <!-- THÔNG BÁO QUAN TRỌNG -->
    <div class="alert-premium">
        <i class="bi bi-info-circle-fill"></i>  
        Key sẽ <b>kích hoạt khi đăng nhập lần đầu</b>.  
        Sau khi kích hoạt, key sẽ hết hạn sau <b><?= esc(session()->getFlashdata('duration')) ?> giờ</b>.
    </div>

</div>

<?php endif; ?>


<!-- ===================================================
     MULTI KEY
=================================================== -->
<?php if (session()->getFlashdata('generated_keys')) :
    $list = array_map('trim', session()->getFlashdata('generated_keys'));
?>
<div class="info-card" style="background:#e3f8ff">
    <h5 class="text-primary"><i class="bi bi-grid-3x3-gap-fill"></i> <?= count($list) ?> Keys Generated</h5>
    <textarea class="form-control mt-2" rows="4" readonly><?= esc(implode("\n", $list)) ?></textarea>

    <button class="btn btn-primary mt-2" onclick="copyText(`<?= esc(implode("\\n", $list), 'js') ?>`)">
        <i class="bi bi-clipboard"></i> Copy toàn bộ
    </button>
</div>
<?php endif; ?>


<!-- ===================================================
     FORM TẠO KEY
=================================================== -->
<div class="info-card mt-3">

    <h4><i class="bi bi-sliders"></i> Nhập Thông Tin</h4>
    <hr>

    <?= form_open() ?>

        <div class="mb-3">
            <label class="form-label">Games <span class="text-danger">*</span></label>
            <?php 
            $selectedGame = old('game');
            if (empty($selectedGame)) {
                $selectedGame = '';
            }
            echo form_dropdown(['class' => 'form-select', 'name' => 'game', 'id' => 'game', 'required' => 'required'], 
                              $game, $selectedGame);
            ?>
            <?php if (session('errors.game')): ?>
                <div class="invalid-feedback d-block">
                    <?= session('errors.game') ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="mb-3">
            <label class="form-label">Loại Key <span class="text-danger">*</span></label>
            <?php 
            $selectedType = old('key_type');
            if (empty($selectedType)) {
                $selectedType = 'regular';
            }
            echo form_dropdown(['class' => 'form-select', 'name' => 'key_type', 'id' => 'key_type', 'required' => 'required'], 
                              $key_types, $selectedType);
            ?>
            <?php if (session('errors.key_type')): ?>
                <div class="invalid-feedback d-block">
                    <?= session('errors.key_type') ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="mb-3">
            <label class="form-label">Max Devices <span class="text-danger">*</span></label>
            <input type="number" class="form-control <?= session('errors.max_devices') ? 'is-invalid' : '' ?>" 
                   id="max_devices" name="max_devices" 
                   min="1" value="<?= esc(old('max_devices') ?? 1) ?>" required>
            <?php if (session('errors.max_devices')): ?>
                <div class="invalid-feedback">
                    <?= session('errors.max_devices') ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="mb-3">
            <label class="form-label">Thời Gian <span class="text-danger">*</span></label>
            <?php 
            $selectedDuration = old('duration');
            if (empty($selectedDuration)) {
                $selectedDuration = '';
            }
            echo form_dropdown(['class' => 'form-select', 'name' => 'duration', 'id' => 'duration', 'required' => 'required'], 
                              $duration, $selectedDuration);
            ?>
            <?php if (session('errors.duration')): ?>
                <div class="invalid-feedback d-block">
                    <?= session('errors.duration') ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- PHẦN MỚI: CHỌN KIỂU TẠO KEY -->
        <div class="mb-3 key-gen-type">
            <label class="form-label">Kiểu Tạo Key <span class="text-danger">*</span></label>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="key_gen_type" id="random_key" value="random" 
                       <?= (old('key_gen_type') == 'random' || !old('key_gen_type')) ? 'checked' : '' ?> required>
                <label class="form-check-label" for="random_key">
                    <i class="bi bi-shuffle"></i> Tạo Key Ngẫu Nhiên (10 ký tự)
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="key_gen_type" id="custom_key_type" value="custom"
                       <?= old('key_gen_type') == 'custom' ? 'checked' : '' ?>>
                <label class="form-check-label" for="custom_key_type">
                    <i class="bi bi-pencil-square"></i> Nhập Key Tùy Chỉnh
                </label>
            </div>
            <?php if (session('errors.key_gen_type')): ?>
                <div class="invalid-feedback d-block">
                    <?= session('errors.key_gen_type') ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- TRƯỜNG NHẬP KEY TÙY CHỈNH -->
        <div class="mb-3 custom-key-field" id="custom_key_field" style="display: none;">
            <label class="form-label">Nhập Key Tùy Chỉnh <span class="text-danger">*</span></label>
            <input type="text" class="form-control <?= session('errors.custom_key') ? 'is-invalid' : '' ?>" 
                   id="custom_key" name="custom_key" 
                   placeholder="Vui Lòng Nhâph Key!" 
                   value="<?= esc(old('custom_key') ?? '') ?>">
            
            <?php if (session('errors.custom_key')): ?>
                <div class="invalid-feedback">
                    <?= session('errors.custom_key') ?>
                </div>
            <?php endif; ?>
            
            <div class="key-example">
                <i class="bi bi-info-circle"></i> Định dạng: => 4 ký tự<br>
                <i class="bi bi-check-circle"></i> Cho phép tất cả ký tự<br>
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label">Số Lượng Key <span class="text-danger">*</span></label>
            <select class="form-select <?= session('errors.loopcount') ? 'is-invalid' : '' ?>" 
                    name="loopcount" id="loopcount" required>
                <option value="1" <?= old('loopcount') == 1 ? 'selected' : '' ?>>1</option>
                <?php if ($user->level == 1) : ?>
                <option value="5" <?= old('loopcount') == 5 ? 'selected' : '' ?>>5</option>
                <option value="10" <?= old('loopcount') == 10 ? 'selected' : '' ?>>10</option>
                <option value="50" <?= old('loopcount') == 50 ? 'selected' : '' ?>>50</option>
                <option value="100" <?= old('loopcount') == 100 ? 'selected' : '' ?>>100</option>
                <?php endif; ?>
            </select>
            <?php if (session('errors.loopcount')): ?>
                <div class="invalid-feedback">
                    <?= session('errors.loopcount') ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="mb-3">
            <label class="form-label">Tổng Tiền (VND)</label>
            <input type="text" readonly id="estimation" class="form-control bg-light">
            <small class="text-muted">Số dư hiện tại: <?= number_format($user->saldo) ?> VND</small>
        </div>

        <button type="submit" class="btn btn-primary w-100 py-2">
            <i class="bi bi-key-fill"></i> XÁC NHẬN TẠO KEY
        </button>

    <?= form_close() ?>
</div>

</div></div>

<script>
function copyText(text) {
    navigator.clipboard.writeText(text).then(function() {
        // Tạo thông báo đẹp hơn
        const alertDiv = document.createElement('div');
        alertDiv.className = 'alert alert-success alert-dismissible fade show position-fixed';
        alertDiv.style.cssText = 'top: 20px; right: 20px; z-index: 9999;';
        alertDiv.innerHTML = `
            <i class="bi bi-check-circle"></i> Đã copy thành công!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        document.body.appendChild(alertDiv);
        
        // Tự động xóa sau 3 giây
        setTimeout(() => {
            if (alertDiv.parentNode) {
                alertDiv.remove();
            }
        }, 3000);
    }).catch(function(err) {
        alert('Lỗi khi copy: ' + err);
    });
}

$(document).ready(function() {
    const price = JSON.parse('<?= $price ?>');
    
    // Xử lý hiển thị/ẩn trường nhập key tùy chỉnh
    function toggleCustomKeyField() {
        if ($('#custom_key_type').is(':checked')) {
            $('#custom_key_field').show();
            $('#custom_key').prop('required', true);
        } else {
            $('#custom_key_field').hide();
            $('#custom_key').prop('required', false);
            $('#custom_key').val('');
        }
    }
    
    // Gắn sự kiện khi thay đổi radio button
    $('input[name="key_gen_type"]').change(function() {
        toggleCustomKeyField();
        calc();
    });
    
    // Gọi lần đầu để thiết lập đúng trạng thái
    toggleCustomKeyField();
    
    // Tính toán tổng tiền
    function calc() {
        let device = parseInt($("#max_devices").val()) || 0;
        let duration = $("#duration").val();
        let keyType = $("#key_type").val();
        let loop = parseInt($("#loopcount").val()) || 1;
        
        let base = price[duration] || 0;
        if (keyType === "vip") base *= 1.5;
        
        let total = device * base * loop;
        $("#estimation").val(total.toLocaleString('vi-VN') + ' VND');
        
        // Kiểm tra số dư
        let currentBalance = <?= $user->saldo ?>;
        if (total > currentBalance) {
            $("#estimation").removeClass('bg-light').addClass('bg-danger text-white');
        } else {
            $("#estimation").removeClass('bg-danger text-white').addClass('bg-light');
        }
    }
    
    // Gắn sự kiện tính toán
    $("#max_devices, #duration, #key_type, #loopcount").on('change input', calc);
    
    // Tính toán lần đầu
    calc();
    
    // Tự động tạo key ngẫu nhiên mẫu khi chọn random
    $('#random_key').change(function() {
        if ($(this).is(':checked')) {
            // Có thể hiển thị key mẫu
            console.log("Sẽ tạo key ngẫu nhiên 10 ký tự");
        }
    });
    
    // Xử lý form submit
    $('form').submit(function(e) {
        // Kiểm tra số dư
        let estimationText = $('#estimation').val();
        let total = parseFloat(estimationText.replace(/[^0-9]/g, ''));
        let currentBalance = <?= $user->saldo ?>;
        
        if (total > currentBalance) {
            e.preventDefault();
            alert('Số dư không đủ! Vui lòng nạp thêm tiền.');
            return false;
        }
        
        // Kiểm tra custom key nếu chọn custom
        if ($('#custom_key_type').is(':checked')) {
            let customKey = $('#custom_key').val().trim();
            if (customKey.length < 4 || customKey.length > 64) {
                e.preventDefault();
                alert('Key tùy chỉnh phải từ => 4 ký tự!');
                return false;
            }
        }
        
        return true;
    });
});
</script>

<?= $this->endSection() ?>