<?= $this->extend('Layout/Starter') ?>
<?= $this->section('content') ?>

<main class="flex-grow-1">
    <div class="row justify-content-center pt-5">
        <div class="col-lg-5 col-md-7">
            <div class="card shadow-lg border-0 rounded-4 mb-5">
                <div class="card-header text-center bg-primary text-white fw-bold py-3">
                    <i class="bi bi-person-plus-fill"></i> TẠO TÀI KHOẢN
                </div>
                <div class="card-body p-4">
                    <?= form_open() ?>
                    
                    <!-- Họ tên -->
                    <div class="mb-3">
                        <label for="fullname" class="form-label">Họ Tên</label>
                        <input type="text" class="form-control <?= $validation->hasError('fullname') ? 'is-invalid' : '' ?>" 
                               name="fullname" id="fullname" placeholder="VD: Nguyễn Văn A" 
                               maxlength="64" value="<?= old('fullname') ?>" required>
                        <div class="invalid-feedback"><?= $validation->getError('fullname') ?></div>
                    </div>

                    <!-- Username -->
                    <div class="mb-3">
                        <label for="username" class="form-label">Tên Đăng Nhập</label>
                        <input type="text" class="form-control <?= $validation->hasError('username') ? 'is-invalid' : '' ?>" 
                               name="username" id="username" placeholder="Tên đăng nhập (4-24 ký tự)" 
                               minlength="4" maxlength="24" value="<?= old('username') ?>" required>
                        <div class="invalid-feedback"><?= $validation->getError('username') ?></div>
                    </div>

                    <!-- Mật khẩu -->
                    <div class="mb-3">
                        <label for="password" class="form-label">Mật Khẩu</label>
                        <input type="password" class="form-control <?= $validation->hasError('password') ? 'is-invalid' : '' ?>" 
                               name="password" id="password" placeholder="Mật khẩu (6-24 ký tự)" 
                               minlength="6" maxlength="24" required>
                        <div class="invalid-feedback"><?= $validation->getError('password') ?></div>
                    </div>

                    <!-- Nhập lại mật khẩu -->
                    <div class="mb-3">
                        <label for="password2" class="form-label">Nhập Lại Mật Khẩu</label>
                        <input type="password" class="form-control <?= $validation->hasError('password2') ? 'is-invalid' : '' ?>" 
                               name="password2" id="password2" placeholder="Xác nhận mật khẩu" 
                               minlength="6" maxlength="24" required>
                        <div class="invalid-feedback"><?= $validation->getError('password2') ?></div>
                    </div>

                    <!-- Referral -->
                    <div class="mb-3">
                        <label for="referral" class="form-label">Mã Xác Minh</label>
                        <input type="text" class="form-control <?= $validation->hasError('referral') ? 'is-invalid' : '' ?>" 
                               name="referral" id="referral" placeholder="Nhập mã xác minh" 
                               value="<?= old('referral') ?>" maxlength="25" required>
                        <div class="invalid-feedback"><?= $validation->getError('referral') ?></div>
                    </div>

                    <!-- Nút submit -->
                    <div class="d-grid mt-4">
                        <button type="submit" class="btn btn-success btn-lg">
                            <i class="bi bi-person-check-fill"></i> Đăng Ký
                        </button>
                    </div>
                    
                    <?= form_close() ?>
                </div>
            </div>

            <!-- Footer nhỏ -->
            <div class="text-center mt-3 mb-5">
                <p class="text-muted">
                    Đã có tài khoản? 
                    <a href="<?= site_url('login') ?>" class="fw-bold text-primary">Đăng nhập ngay</a>
                </p>
            </div>
        </div>
    </div>
</main>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<?php if (session()->getFlashdata('msg')) : ?>
<script>
Swal.fire({
    icon: 'info',
    title: 'Thông báo',
    text: "<?= session()->getFlashdata('msg') ?>",
    showConfirmButton: false,
    timer: 2000
});
</script>
<?php endif; ?>

<style>
html, body {
    height: 100%;
}
body {
    display: flex;
    flex-direction: column;
    min-height: 100vh;
}
main {
    flex: 1;
}
</style>

<?= $this->endSection() ?>