<?= $this->extend('Layout/Starter') ?>

<?= $this->section('content') ?>
    <div class="col-lg-12">
        <div class="alert alert-primary" role="alert">
            <strong>THÔNG TIN</strong> &middot; DANH SÁCH QUẢN LÝ USERS.
        </div>
        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white h6 p-3">
                Quản lý <?= $title ?>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="datatable" class="table table-bordered table-hover text-center" style="width:100%">
                        <thead>
                            <tr>
                                <th scope="row">#</th>
                                <th>Tên đăng nhập</th>
                                <th>Tên đủ</th>
                                <th>Vai trò</th>
                                <th>Tiền</th>
                                <th>Trạng thái</th>
                                <th>Người mời</th>
                                <th>Logo</th> <!-- 🆕 Thêm cột hiển thị logo -->
                                <th>Hành động</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('css') ?>
<?= link_tag("https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap5.min.css") ?>
<?= $this->endSection() ?>

<?= $this->section('js') ?>
<?= script_tag("https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js") ?>
<?= script_tag("https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js") ?>

<script>
    $(document).ready(function() {
        var table = $('#datatable').DataTable({
            processing: true,
            serverSide: true,
            order: [[0, "desc"]],
            ajax: "<?= site_url('admin/api/users') ?>",
            columns: [
                { data: 'id' },
                { data: 'username' },
                {
                    data: 'fullname',
                    render: function(data, type, row, meta) {
                        return (row.fullname ? row.fullname : '~');
                    }
                },
                { data: 'level' },
                {
                    data: 'saldo',
                    render: function(data, type, row, meta) {
                        var textc = (row.level === 'Admin' ? 'primary' : 'dark');
                        var saldo = (row.level === 'Admin' ? '&mstpos;' : row.saldo);
                        return `<span class="badge text-${textc}">${saldo}</span>`;
                    }
                },
                {
                    data: 'status',
                    render: function(data, type, row, meta) {
                        var act = `<span class="text-success">Active</span>`;
                        var ban = `<span class="text-danger">Banned</span>`;
                        return (row.status == 1 ? act : ban);
                    }
                },
                { data: 'uplink' },

                // 🆕 Cột hiển thị logo
                {
                    data: 'logo',
                    render: function(data, type, row, meta) {
                        if (row.logo && row.logo !== '') {
                            return `<img src="${row.logo}" alt="logo" class="rounded-circle" style="width:40px;height:40px;object-fit:cover;">`;
                        } else {
                            return `<span class="text-muted">Không có</span>`;
                        }
                    }
                },

                {
                    data: null,
                    render: function(data, type, row, meta) {
                        return `<a href="${window.location.origin}/public/admin/user/${row.id}" class="btn btn-primary btn-sm">Chỉnh sửa</a>`;
                    }
                }
            ]
        });
    });
</script>

<?= $this->endSection() ?>