<?= $this->extend('Layout/Starter') ?>

<?= $this->section('content') ?>
<div class="row justify-content-center pt-3">
    <div class="col-lg-8">
        <?= $this->include('Layout/msgStatus') ?>
    </div>
    <div class="col-lg-8 mb-3">
        <div class="card mb-5">
            <div class="card-header p-3 h5 bg-primary text-white">
                Chỉnh tài khoản &middot; <?= getName($target) ?>
            </div>
            <div class="card-body">
                <?= form_open() ?>
                <input type="hidden" name="user_id" value="<?= $target->id_users ?>">
                <div class="row">
                    <div class="col-md-6 mb-2">
                        <label for="username" class="form-label">Tên Đăng nhập</label>
                        <input type="text" name="username" id="username" class="form-control" placeholder="" aria-describedby="help-username" value="<?= old('username') ?: $target->username ?>">
                        <?php if ($validation->hasError('username')) : ?>
                            <small id="help-username" class="form-text text-danger"><?= $validation->getError('username') ?></small>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6 mb-2">
                        <label for="fullname" class="form-label">Tên đầy đủ</label>
                        <input type="text" name="fullname" id="fullname" class="form-control" placeholder="" aria-describedby="help-fullname" value="<?= old('fullname') ?: $target->fullname ?>">
                        <?php if ($validation->hasError('fullname')) : ?>
                            <small id="help-fullname" class="form-text text-danger"><?= $validation->getError('fullname') ?></small>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="level" class="form-label">Vai trò</label>
                        <?php $sel_level = ['' => '&mdash; Select Roles &mdash;', '1' => 'Admin', '2' => 'Reseller']; ?>
                        <?= form_dropdown(['class' => 'form-select', 'name' => 'level', 'id' => 'level'], $sel_level, $target->level) ?>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="status" class="form-label">Trạng thái</label>
                        <?php $sel_status = ['' => '&mdash; Select Status &mdash;', '0' => 'Banned/Block', '1' => 'Active']; ?>
                        <?= form_dropdown(['class' => 'form-select', 'name' => 'status', 'id' => 'status'], $sel_status, $target->status) ?>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="saldo" class="form-label">Tiền</label>
                        <input type="number" name="saldo" id="saldo" class="form-control" placeholder="" aria-describedby="help-saldo" value="<?= old('saldo') ?: $target->saldo ?>">
                        <?php if ($validation->hasError('saldo')) : ?>
                            <small id="help-saldo" class="form-text text-danger"><?= $validation->getError('saldo') ?></small>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="uplink" class="form-label">Người mời</label>
                        <input type="text" name="uplink" id="uplink" class="form-control" placeholder="" aria-describedby="help-uplink" value="<?= old('uplink') ?: $target->uplink ?>">
                        <?php if ($validation->hasError('uplink')) : ?>
                            <small id="help-uplink" class="form-text text-danger"><?= $validation->getError('uplink') ?></small>
                        <?php endif; ?>
                    </div>

                    <!-- 🆕 Thêm chỗ nhập link logo -->
                    <div class="col-md-12 mb-3">
                        <label for="logo" class="form-label">Logo (URL hình ảnh)</label>
                        <input type="url" name="logo" id="logo" class="form-control" placeholder="https://example.com/logo.png" value="<?= old('logo') ?: $target->logo ?>">
                        <?php if ($validation->hasError('logo')) : ?>
                            <small id="help-logo" class="form-text text-danger"><?= $validation->getError('logo') ?></small>
                        <?php endif; ?>
                        
                        <!-- 🖼️ Preview ảnh -->
                        <?php if (!empty($target->logo)) : ?>
                            <div class="mt-2">
                                <img src="<?= esc($target->logo) ?>" alt="User Logo" class="rounded shadow-sm border" style="width: 100px; height: 100px; object-fit: cover;">
                            </div>
                        <?php else: ?>
                            <small class="text-muted">Chưa có logo.</small>
                        <?php endif; ?>
                    </div>
                    <!-- ✅ Kết thúc phần logo -->

                    <div class="col-md-12 mt-2">
                        <button type="submit" class="btn btn-outline-primary">Cập nhập tài khoản</button>
                    </div>
                </div>
                <?= form_close() ?>
            </div>
        </div>

        <p class="text-muted text-center">
            <a href="<?= site_url('admin/manage-users') ?>" class="py-1 px-2 bg-white text-muted">
                <small><i class="bi bi-arrow-left"></i> Trở lại</small>
            </a>
        </p>
    </div>
</div>
<?= $this->endSection() ?>