<?= $this->extend('Layout/Starter') ?><?= $this->section('content') ?><div class="row">  <div class="col-lg-12">  
    <?= $this->include('Layout/msgStatus') ?>  
</div>  
<div class="col-lg-4 mb-3">  
    <div class="card">  
        <div class="card-header p-3 h6 bg-primary text-white">  
            Tạo mã <?= $title ?>  
        </div>  
        <div class="card-body">  
            <?= form_open() ?><div class="form-group mb-3">  
            <label for="set_saldo">Số tiền tính theo VND </label>  
            <div class="input-group mt-2">  
                <span class="input-group-text"><i class="bi bi-currency-dollar"></i></span>  
                <input type="number" class="form-control" name="set_saldo" id="set_saldo" minlength="1" maxlength="11" value="5000">  
            </div>  
            <?php if ($validation->hasError('set_saldo')) : ?>  
                <small id="help-saldo" class="text-danger"><?= $validation->getError('set_saldo') ?></small>  
            <?php endif; ?>  
        </div>  
        <div class="form-group">  
            <button type="submit" class="btn btn-primary w-100">Tạo mã</button>  
        </div>  
        <?= form_close() ?>  
        <hr>  
        <?php if (isset($new_code)) : ?>  
            <div class="alert alert-success mt-3">  
                Mã ref mới (chưa mã hoá): <strong><?= $new_code ?></strong>  
            </div>  
        <?php endif; ?>  
    </div>  
</div>  

<div class="card mt-4">  
    <div class="card-header p-3 h6 bg-secondary text-white">  
        Tạo tài khoản mới  
    </div>  
    <div class="card-body">  
        <?= form_open('admin/taoaccusers') ?>  
        <div class="form-group mb-3">  
            <label for="fullname">Họ tên</label>  
            <input type="text" name="fullname" id="fullname" class="form-control" required>  
        </div>  
        <div class="form-group mb-3">  
            <label for="username">Tài khoản</label>  
            <input type="text" name="username" id="username" class="form-control" required>  
        </div>  
        <div class="form-group mb-3">  
            <label for="password">Mật khẩu</label>  
            <input type="password" name="password" id="password" class="form-control" required>  
        </div>  
        <div class="form-group">  
            <button type="submit" class="btn btn-success w-100">Tạo tài khoản</button>  
        </div>  
        <?= form_close() ?>  
    </div>  
</div>

</div>  
<div class="col-lg-8">  
    <?php if ($code) : ?>  
        <div class="card">  
            <div class="card-header p-3 h6 bg-primary text-white">  
                Lịch sử tạo - Tổng cộng <?= $total_code ?>  
            </div>  
            <div class="card-body">  
                <div class="table-responsive">  
                    <table class="table table-bordered table-hover text-center align-middle" style="width:100%">  
                        <thead class="table-light">  
                            <tr>  
                                <th>#</th>  
                                <th>Mã đã mã hoá</th>  
                                <th>Tiền</th>  
                                <th>Dùng bởi</th>  
                                <th>Tạo bởi</th>  
                                <th>Ngày tạo</th>  
                                <th>Thao tác</th>  
                            </tr>  
                        </thead>  
                        <tbody>  
                            <?php foreach ($code as $c) : ?>  
                                <tr class="<?= $c->used_by ? 'table-success' : '' ?>">  
                                    <td><?= $c->id_reff ?></td>  
                                    <td><code><?= substr($c->code, 0, 5) ?>...<?= substr($c->code, -5) ?></code></td>  
                                    <td><?= number_format($c->set_saldo) ?>₫</td>  
                                    <td>  
                                        <?php if ($c->used_by) : ?>  
                                            <span class="badge bg-success"><i class="bi bi-person-check"></i> <?= $c->used_by ?></span>  
                                        <?php else : ?>  
                                            <span class="text-muted">Chưa sử dụng</span>  
                                        <?php endif; ?>  
                                    </td>  
                                    <td><?= $c->created_by ?></td>  
                                    <td><?= date('d/m/Y', strtotime($c->created_at)) ?></td>  
                                    <td>  
                                        <?php if (!$c->used_by) : ?>  
                                            <button class="btn btn-sm btn-outline-danger delete-btn" data-id="<?= $c->id_reff ?>">  
                                                <i class="bi bi-trash"></i>  
                                            </button>  
                                        <?php else : ?>  
                                            <span class="text-muted">Đã sử dụng</span>  
                                        <?php endif; ?>  
                                    </td>  
                                </tr>  
                            <?php endforeach; ?>  
                        </tbody>  
                    </table>  
                </div>  
            </div>  
        </div>  
    <?php endif; ?>  
</div>  </div><!-- Modal xác nhận xoá --><div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">  
    <div class="modal-dialog">  
        <div class="modal-content">  
            <div class="modal-header bg-danger text-white">  
                <h5 class="modal-title">Xác nhận xoá</h5>  
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>  
            </div>  
            <div class="modal-body">  
                <p>Bạn có chắc chắn muốn xoá mã này? Hành động này không thể hoàn tác.</p>  
            </div>  
            <div class="modal-footer">  
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Huỷ</button>  
                <a href="#" id="confirmDelete" class="btn btn-danger">Xoá</a>  
            </div>  
        </div>  
    </div>  
</div><?= $this->endSection() ?><?= $this->section('scripts') ?><script>  
$(document).ready(function() {  
    $('.delete-btn').click(function() {  
        const id = $(this).data('id');  
        $('#confirmDelete').attr('href', '<?= site_url("referral/delete") ?>/' + id);  
        $('#deleteModal').modal('show');  
    });  
});  
</script><?= $this->endSection() ?>  