<?php

namespace App\Controllers;

use App\Models\ReferralModel;
use CodeIgniter\Controller;

class Referral extends BaseController
{
    protected $model;
    protected $validation;
    protected $session;

    public function __construct()
    {
        $this->model = new ReferralModel();
        $this->validation = \Config\Services::validation();
        $this->session = session();
    }

    public function index()
    {
        helper(['form', 'text']);

        if ($this->request->getMethod() === 'post') {
            $set_saldo = (int) $this->request->getPost('set_saldo');

            $rules = [
                'set_saldo' => 'required|greater_than_equal_to[1000]'
            ];

            if (!$this->validate($rules)) {
                return view('referral/index', [
                    'validation' => $this->validation,
                    'title' => 'nạp tiền',
                    'code' => $this->model->orderBy('id_reff', 'DESC')->findAll(),
                    'total_code' => $this->model->countAll(),
                ]);
            }

            $code = strtoupper(random_string('alnum', 20));
            $this->model->insert([
                'code'        => $code,
                'set_saldo'   => $set_saldo,
                'created_by'  => $this->session->get('username'),
                'created_at'  => date('Y-m-d H:i:s'),
            ]);

            return redirect()->to(current_url())->with('success', 'Tạo mã thành công!');
        }

        return view('referral/index', [
            'title'       => 'nạp tiền',
            'code'        => $this->model->orderBy('id_reff', 'DESC')->findAll(),
            'total_code'  => $this->model->countAll(),
            'validation'  => $this->validation
        ]);
    }

    public function delete($id = null)
    {
        if (!$id) {
            return redirect()->back()->with('error', 'ID không hợp lệ');
        }

        $row = $this->model->find($id);

        if (!$row) {
            return redirect()->back()->with('error', 'Mã không tồn tại');
        }

        if ($row->used_by) {
            return redirect()->back()->with('error', 'Mã đã được sử dụng, không thể xoá');
        }

        $this->model->delete($id);

        return redirect()->back()->with('success', 'Xoá mã thành công');
    }
}