<?php
namespace App\Controllers;

use App\Models\CodeModel;
use App\Models\UserModel;
use CodeIgniter\Config\Services;

class Auth extends BaseController
{
    protected $userModel;

    public function __construct()
    {
        $this->userModel = new UserModel();
    }

    public function index()
    {
        $a = $this->userModel->getUser(session('userid'));
        dd($a, session());
    }

    public function login()
    {
        if (session()->has('userid'))
            return redirect()->to('dashboard');

        if ($this->request->getPost())
            return $this->login_action();

        $data = [
            'title' => 'Login',
            'validation' => Services::validation(),
        ];
        return view('Auth/login', $data);
    }

    public function register()
    {
        if (session()->has('userid'))
            return redirect()->to('dashboard');

        if ($this->request->getPost())
            return $this->register_action();

        $data = [
            'title' => 'Register',
            'validation' => Services::validation(),
        ];
        return view('Auth/register', $data);
    }

    private function login_action()
    {
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');
        $stay_log = $this->request->getPost('stay_log');

        $form_rules = [
            'username' => [
                'label' => 'username',
                'rules' => 'required|alpha_numeric|min_length[4]|max_length[25]|is_not_unique[users.username]',
                'errors' => [
                    'is_not_unique' => 'The {field} is not registered.'
                ]
            ],
            'password' => [
                'label' => 'password',
                'rules' => 'required|min_length[6]|max_length[45]',
            ],
            'stay_log' => [
                'rules' => 'permit_empty|max_length[3]'
            ]
        ];

        if (!$this->validate($form_rules)) {
            return redirect()->route('login')->withInput()->with('msgDanger', '<strong>Failed</strong> Please check the form.');
        }

        $validation = Services::validation();
        $cekUser = $this->userModel->getUser($username, 'username');

        if ($cekUser) {
            if (password_verify($password, $cekUser->password)) {
                $time = new \CodeIgniter\I18n\Time;
                $data = [
                    'userid' => $cekUser->id_users,
                    'unames' => $cekUser->username,
                    'time_login' => $stay_log ? $time::now()->addHours(24) : $time::now()->addMinutes(30),
                    'time_since' => $time::now(),
                ];
                session()->set($data);
                return redirect()->to('dashboard');
            } else {
                $validation->setError('password', 'Wrong password, please try again.');
                return redirect()->route('login')->withInput()->with('msgDanger', '<strong>Failed</strong> Please check the form.');
            }
        }

        return redirect()->route('login')->withInput()->with('msgDanger', '<strong>Failed</strong> User not found.');
    }

    public function register_action()
    {
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');
        $referral = $this->request->getPost('referral');

        $form_rules = [
            'username' => [
                'label' => 'username',
                'rules' => 'required|alpha_numeric|min_length[4]|max_length[25]|is_unique[users.username]',
                'errors' => [
                    'is_unique' => 'The {field} has been taken.'
                ]
            ],
            'password' => [
                'label' => 'password',
                'rules' => 'required|min_length[6]|max_length[45]',
            ],
            'password2' => [
                'label' => 'password',
                'rules' => 'required|min_length[6]|max_length[45]|matches[password]',
                'errors' => [
                    'matches' => '{field} not match, check the {field}.'
                ]
            ],
            'referral' => [
                'label' => 'referral',
                'rules' => 'required|min_length[6]|alpha_numeric',
            ]
        ];

        if (!$this->validate($form_rules)) {
            return redirect()->route('register')->withInput()->with('msgDanger', '<strong>Failed</strong> Please check the form.');
        }

        $mCode = new CodeModel();
        $rCheck = $mCode->checkCode($referral);
        $validation = Services::validation();

        if (!$rCheck) {
            $validation->setError('referral', 'Wrong referral, please try again.');
        } elseif ($rCheck->used_by) {
            $validation->setError('referral', "Wrong referral, code has been used &middot; $rCheck->used_by.");
        } else {
            $hashPassword = password_hash($password, PASSWORD_DEFAULT);
            $data_register = [
                'username' => $username,
                'password' => $hashPassword,
                'saldo' => $rCheck->set_saldo ?: 0,
                'uplink' => $rCheck->created_by
            ];

            $ids = $this->userModel->insert($data_register, true);
            if ($ids) {
                $mCode->useReferral($referral);
                return redirect()->to('login')->with('msgSuccess', 'Register Successfuly!');
            }
        }

        return redirect()->route('register')->withInput()->with('msgDanger', '<strong>Failed</strong> Please check the form.');
    }

    public function logout()
    {
        if (session()->has('userid')) {
            $unset = ['userid', 'unames', 'time_login', 'time_since'];
            session()->remove($unset);
            session()->setFlashdata('msgSuccess', 'Logout successfuly.');
        }
        return redirect()->to('login');
    }
}