<?php

namespace Config;

use App\Filters\AuthFilter;
use App\Filters\AdminFilter;
use CodeIgniter\Config\BaseConfig;
use CodeIgniter\Filters\CSRF;
use CodeIgniter\Filters\DebugToolbar;
use CodeIgniter\Filters\Honeypot;

class Filters extends BaseConfig
{
	public $aliases = [
		'csrf'     => CSRF::class,
		'toolbar'  => DebugToolbar::class,
		'honeypot' => Honeypot::class,
		'auth'     => AuthFilter::class,
		'admin'    => AdminFilter::class,
	];

	public $globals = [
		'before' => [
			// CSRF chỉ chạy với form web, API connect bỏ qua để giảm delay
			'csrf' => [
				'except' => [
					'connect', 'd', 'k', 'kh', 'b', 'h', 'xtff', 'km', 'enc', 'keys/delete_bulk'
				],
			],
			'auth' => [
				'except' => [
					'/', 'login', 'register', 'connect', 'd', 'k', 'kh', 'b', 'h', 'xtff', 'km', 'enc',
				],
			],
		],
		'after' => [
			// Không bật DebugToolbar để giảm chi phí xử lý
		],
	];

	public $methods = [];
	public $filters = [];
}